function [ Y_1,Y_2,Y_3 ] = WangZ_PilotTransmission(G,H_d,H_r,options,akt,phint)
%WANGZ_PILOTTRANSMISSION Summary of this function goes here
%   Detailed explanation goes here

%% Phase 1: estimate the channel between the BS and the UE
A_1 = dftmtx(options.K);
Y_1 = H_d*A_1*sqrt(options.Tx_power) + (normrnd(0,1,options.M,options.K) + 1i*normrnd(0,1,options.M,options.K))*sqrt(options.noise_var/2);

%% Phase 2: estimate a reference UE 
Y_2 = zeros(options.M,options.N);
Phi = dftmtx(options.N);
for n = 1:options.N
    Y_2(:,n) = H_d(:,1)*sqrt(options.Tx_power) + G*diag(Phi(:,n))*H_r(:,1)*sqrt(options.Tx_power) + (normrnd(0,1,options.M,1) + 1i*normrnd(0,1,options.M,1))*sqrt(options.noise_var/2);
end

%% Phase 3: estimate all other UEs
% case 1: M>=N
if (options.M>=options.N)
    A_3 = dftmtx(options.K-1);
    Y_3 = zeros(options.M,options.K);
    for k = 2:options.K
        Y_3(:,k) = H_d(:,2:options.K)*A_3(:,k-1)*sqrt(options.Tx_power) + G*H_r(:,2:options.K)*A_3(:,k-1)*sqrt(options.Tx_power) + (normrnd(0,1,options.M,1) + 1i*normrnd(0,1,options.M,1))*sqrt(options.noise_var/2);
    end
end
        
% case 2: M<N
if (options.M<options.N)
    T3 = ceil((options.K-1)*options.N/options.M);
    Y_3 = zeros(options.M*T3,1);       
    for t=1:T3
        for k = 2:options.K
            Y_3(((t-1)*options.M+1):t*options.M) = Y_3(((t-1)*options.M+1):t*options.M) + akt(k,t)*H_d(:,k)*sqrt(options.Tx_power) + akt(k,t)*G*diag(phint(:,t))*H_r(:,k)*sqrt(options.Tx_power);
        end
        Y_3(((t-1)*options.M+1):t*options.M) = Y_3(((t-1)*options.M+1):t*options.M) + (normrnd(0,1,options.M,1) + 1i*normrnd(0,1,options.M,1))*sqrt(options.noise_var/2);
    end
end

end

